<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Transaction;
use App\Models\TransactionDetail;
use App\Models\TravelPackage;
use Carbon\Carbon;

use Midtrans\Config;
use Midtrans\Snap;

class CheckoutController extends Controller
{
    public function index(Request $request, $id)
    {
        $item = Transaction::with(['details', 'travel_package', 'user'])->findOrFail($id);

        return view('pages.checkout', [
            'item' => $item
        ]);
    }

    public function process(Request $request, $id)
    {
        $travel_package = TravelPackage::findOrFail($id);

        $transaction = Transaction::create([
            'travel_packages_id' => $id,
            'users_id' => Auth::user()->id,
            'additional_visa' => 0,
            'transaction_total' => $travel_package->price,
            'transaction_status' => 'IN_CART'
        ]);

        TransactionDetail::create([
            'transactions_id' => $transaction->id,
            'username' => Auth::user()->username,
            'nationality' => 'ID',
            'is_visa' => false,
            'doe_passport' => carbon::now()->addYears(5)
        ]);

        return redirect()->route('checkout', $transaction->id);
    }

    public function remove(Request $request, $detail_id)
    {
        $item = TransactionDetail::findOrFail($detail_id);

        $transaction = Transaction::with(['details', 'travel_package'])
            ->findOrFail($item->transactions_id);

        
            if($item->is_visa)
            {
                $transaction ->transaction_total -= 190;
                $transaction ->additional_visa -= 190;
            }
    
            $transaction->transaction_total -= $transaction->travel_package->price;
    
            $transaction->save();
            $item->delete();

            return redirect()->route('checkout', $item->transactions_id);
    }

    public function create(Request $request, $id)
    {
        //validasi
        $request->validate([
            'username' => 'required|string|exists:users,username',
            'is_visa' => 'required|boolean',
            'doe_passport' => 'required'
        ]);

        //mengatur datn untuk dimasukkan ke transaction_detail
        $data = $request->all();
        $data['transactions_id'] = $id;

        //insert data
        TransactionDetail::create($data);
        // mengambil data transsaction
        $transaction = Transaction::with(['travel_package'])->find($id);

        //update total transaksi saat menambah user baru
        if($request->is_visa)
        {
            $transaction ->transaction_total += 190;
            $transaction ->additional_visa += 190;
        }

        $transaction->transaction_total += $transaction->travel_package->price;

        $transaction->save();

        return redirect()->route('checkout', $id);
    }

    public function success(Request $request, $id)
    {
        $transaction = Transaction::findOrFail($id);
        $transaction->transaction_status = 'PENDING';

        $transaction->save();

        // set konfigurasi midtrans
        config::$serverKey = config('midtrans.serverKey');
        
        config::$isProduction = config('midtrans.isProduction');
        config::$isSanitized = config('midtrans.isSanitized');
        config::$is3ds = config('midtrans.is3ds');

        // buat array untk dikirim ke midtrans
        $midtrans_params = [
            'transaction_details' => [
                'order_id' => 'AHAYSHOP-'. $transaction->id,
                'gross_amount' => (int) $transaction->transaction_total
            ],
            'customer_details' =>[
                'first_name' => $transaction->user->name,
                'email' => $transaction->user->email
            ],
            'enabled_payments' => 'gopay', 'shopeepay',
            'vtweb' => []
        ];

        try {
            // ambil halaman payment midtrans
            $paymentUrl = Snap::createTransaction($midtrans_params)->redirect_url;
            

            // redicet ke halaman payment
            header('Location: ' . $paymentUrl);
            exit();
        } catch (Exception $e) {
            echo $e->getMessage();
        }

    }
}
