<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TravelPackage extends Model
{
    use HasFactory;

    protected $fillable = [
        'title', 'slug', 'location', 'about', 'featured_event', 'languange', 'foods', 'departure_date', 'duration', 'type', 'price' 
    ];

    protected $hidden = [

    ];
    
    /**
     * Get all of the galleries for the TravelPackage
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function galleries()
    {
        return $this->hasMany(Gallery::class, 'travel_packages_id', 'id');
    }
}
